<?php

namespace App\Http\Controllers;

use App\Models\Income;
use Illuminate\Http\Request;

class IncomeController extends Controller
{
    public function index()
    {
        $incomes = Income::with(['report', 'asset', 'user'])->get();
        return response()->json($incomes);
    }

    public function store(Request $request)
    {
        $request->validate([
            'report_id' => 'required|exists:reports,id',
            'asset_id' => 'required|exists:assets,id',
            'amount' => 'required|numeric|min:0',
            'date' => 'required|date',
            'user_id' => 'required|exists:users,id',
        ]);

        $income = Income::create([
            'report_id' => $request->report_id,
            'asset_id' => $request->asset_id,
            'income_number' => 'INC-' . uniqid(),
            'amount' => $request->amount,
            'date' => $request->date,
            'user_id' => $request->user_id
        ]);

        return response()->json($income, 201);
    }

    public function show(Income $income)
    {
        return response()->json($income->load(['report', 'asset', 'user']));
    }

    public function update(Request $request, Income $income)
    {
        $request->validate([
            'report_id' => 'sometimes|exists:reports,id',
            'asset_id' => 'sometimes|exists:assets,id',
            'amount' => 'sometimes|numeric|min:0',
            'date' => 'sometimes|date',
            'user_id' => 'sometimes|exists:users,id',
        ]);

        $income->update($request->all());

        return response()->json($income);
    }

    public function destroy(Income $income)
    {
        $income->delete();
        return response()->json(null, 204);
    }
}