<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    use HasFactory;

    protected $fillable = [
        'report_id',
        'expense_number',
        'asset_id',
        'amount',
        'expense_type_id',
        'user_id'
    ];

    public function report()
    {
        return $this->belongsTo(Report::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function expenseType()
    {
        return $this->belongsTo(ExpenseType::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}