@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Add Expense Type</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="view-expense-types">Expense Types</a></li>
                <li class="breadcrumb-item active">Add</li>
            </ol>
        </nav>
    </div>

    <section class="section">
        <div class="card">
            <div class="card-body pt-3">
                <form id="addExpenseTypeForm">
                    <div class="mb-3">
                        <label for="name" class="form-label">Expense Type Name</label>
                        <input type="text" class="form-control" id="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="component_id" class="form-label">Select Component</label>
                        <select class="form-select" id="component_id" required></select>
                    </div>
                    <button type="submit" class="btn btn-primary">Create Expense Type</button>
                </form>
            </div>
        </div>
    </section>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const token = localStorage.getItem("token");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user ? user.user_id : null;

    // Fetch components for the select dropdown
    fetch("{{ env('APP_URL') . 'api/report-components'}}", {
        headers: { "Authorization": `Bearer ${token}` }
    })
    .then(res => res.json())
    .then(components => {
        const componentSelect = document.getElementById("component_id");
        componentSelect.innerHTML = components.map(component => `
            <option value="${component.id}">${component.name}</option>
        `).join("");
    });

    document.getElementById("addExpenseTypeForm").addEventListener("submit", function (e) {
        e.preventDefault();

        fetch("{{ env('APP_URL') . 'api/expense-types'}}", {
            method: 'POST',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                name: document.getElementById("name").value,
                description: document.getElementById("description").value,
                component_id: document.getElementById("component_id").value, // Send selected component_id
                status: 1,
                user_id: userId // Sending the user_id here
            })
        }).then(() => {
            Swal.fire('Success!', 'Expense Type created successfully.', 'success').then(() => {
                window.location.href = "/view-expense-types";
            });
        });
    });
});
</script>
@endsection
