
@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Incomes</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Incomes</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search incomes...">
                    <button class="btn btn-primary" id="createIncomeBtn">Add New Income</button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="incomesTable">
                            <thead>
                                <tr>
                                    <th>Income Number</th>
                                    <th>Report</th>
                                    <th>Asset</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Created by</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Income Modal -->
    <div class="modal fade" id="incomeModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="incomeForm" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add Income</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="incomeId">
                    <input type="hidden" id="userId">

                    <div class="mb-3">
                        <label class="form-label">Report</label>
                        <select id="reportId" class="form-select" required></select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Asset</label>
                        <select id="assetId" class="form-select" required></select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Amount</label>
                        <input type="number" id="amount" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Date</label>
                        <input type="date" id="date" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Save</button>
                </div>
            </form>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", () => {
    const token = localStorage.getItem("token");
    const tbody = document.querySelector("#incomesTable tbody");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user?.user_id || null;

    const form = document.getElementById("incomeForm");

    function fetchReports() {
        return fetch("{{ env('APP_URL') . 'api/reports'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            const reportsSelect = document.getElementById("reportId");
            reportsSelect.innerHTML = `<option value="">Select Report Number</option>`;
            data.forEach(report => {
                const option = document.createElement("option");
                option.value = report.id;
                option.text = report.report_number;
                reportsSelect.appendChild(option);
            });
        });
    }

    function fetchAssets() {
        return fetch("{{ env('APP_URL') . 'api/assets'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(assets => {
            const assetSelect = document.getElementById("assetId");
            assetSelect.innerHTML = `<option value="">Select Asset</option>`;
            assets.forEach(asset => {
                const option = document.createElement("option");
                option.value = asset.id;
                option.text = asset.name;
                assetSelect.appendChild(option);
            });
        });
    }

    function fetchIncomes() {
        fetch("{{ env('APP_URL') . 'api/incomes'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tbody.innerHTML = data.map(income => `
                <tr>
                    <td>${income.income_number}</td>
                    <td>${income.report?.report_number || '-'}</td>
                    <td>${income.asset?.name || '-'}</td>
                    <td>${income.amount}</td>
                    <td>${income.date}</td>
                    <td>${income.user?.name || '-'}</td>
                    <td>
                        <button class="btn btn-warning btn-sm edit-btn" data-id="${income.id}" data-report="${income.report_id}" data-asset="${income.asset_id}" data-amount="${income.amount}" data-date="${income.date}">Edit</button>
                        <button class="btn btn-danger btn-sm delete-btn" data-id="${income.id}">Delete</button>
                    </td>
                </tr>
            `).join('');
        });
    }

    document.getElementById("createIncomeBtn").addEventListener("click", () => {
        form.reset();
        document.getElementById("modalTitle").textContent = "Add Income";
        document.getElementById("incomeId").value = "";
        document.getElementById("userId").value = userId;
        new bootstrap.Modal(document.getElementById("incomeModal")).show();
    });

    tbody.addEventListener("click", e => {
        const btn = e.target;
        const baseUrl = "{{ env('APP_URL') }}";
        if (btn.classList.contains("edit-btn")) {
            const id = btn.dataset.id;
            document.getElementById("incomeId").value = id;
            document.getElementById("reportId").value = btn.dataset.report;
            document.getElementById("assetId").value = btn.dataset.asset;
            document.getElementById("amount").value = btn.dataset.amount;
            document.getElementById("date").value = btn.dataset.date;
            document.getElementById("modalTitle").textContent = "Edit Income";
            new bootstrap.Modal(document.getElementById("incomeModal")).show();
        }

        if (btn.classList.contains("delete-btn")) {
            const id = btn.dataset.id;
            Swal.fire({
                title: "Delete this income?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!"
            }).then((res) => {
                if (res.isConfirmed) {
                    fetch(`${baseUrl}api/incomes/${id}`, {
                        method: "DELETE",
                        headers: { "Authorization": `Bearer ${token}` }
                    }).then(() => {
                        Swal.fire("Deleted!", "Income removed.", "success");
                        fetchIncomes();
                    });
                }
            });
        }
    });

    form.addEventListener("submit", e => {
        e.preventDefault();
        const id = document.getElementById("incomeId").value;
        const payload = {
            report_id: document.getElementById("reportId").value,
            asset_id: document.getElementById("assetId").value,
            amount: document.getElementById("amount").value,
            date: document.getElementById("date").value,
            user_id: userId
        };

        const url = id ? `${baseUrl}api/incomes/${id}` : `${baseUrl}api/incomes`;
        const method = id ? "PUT" : "POST";

        fetch(url, {
            method: method,
            headers: {
                "Authorization": `Bearer ${token}`,
                "Content-Type": "application/json"
            },
            body: JSON.stringify(payload)
        })
        .then(res => res.json())
        .then(() => {
            Swal.fire(id ? "Updated!" : "Created!", `Income ${id ? "updated" : "created"} successfully.`, "success");
            bootstrap.Modal.getInstance(document.getElementById("incomeModal")).hide();
            fetchIncomes();
        }).catch(() => {
            Swal.fire("Error", "Something went wrong.", "error");
        });
    });

    fetchIncomes();
    fetchAssets();
    fetchReports();
});
</script>
@endsection