@extends('layouts.auth')
@section('content')
<main>
    <div class="container">
        <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-4 col-md-6 d-flex flex-column align-items-center justify-content-center">
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="pt-4 pb-2">
                                    <div class="d-flex justify-content-center py-4">
                                        <a href="/" class="logo d-flex align-items-center w-auto">
                                            <span class="d-none d-lg-block">Emmanuel Business</span>
                                        </a>
                                    </div>
                                </div>
                                <form id="loginForm" class="row g-3 needs-validation" novalidate>
                                    @csrf
                                    <div class="col-12">
                                        <label for="email" class="form-label">Email</label>
                                        <div class="input-group has-validation">
                                            <input type="email" name="email" class="form-control" id="email" required>
                                            <div class="invalid-feedback">Please enter your email.</div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label for="password" class="form-label">Password</label>
                                        <input type="password" name="password" class="form-control" id="password" required>
                                        <div class="invalid-feedback">Please enter your password!</div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn w-100" style="background:#086808; color:#FFFFFF" type="submit">Login</button>
                                    </div>
                                    <div id="error-message" class="text-danger text-center mt-2"></div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.getElementById('loginForm').addEventListener('submit', async function(event) {
        event.preventDefault();
        const form = event.target;
        const formData = new FormData(form);
        const requestData = Object.fromEntries(formData);

        try {
            const response = await fetch("{{ env('APP_URL') . 'api/login'}}", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(requestData),
            });

            const result = await response.json();

            if (response.ok) {
                // Save user details and token in local storage
                localStorage.setItem("user", JSON.stringify(result.user));
                localStorage.setItem("token", result.token);

                Swal.fire("Success", "Login successful!", "success").then(() => {
                    window.location.href = "/home";
                });
            } else {
                document.getElementById("error-message").innerText = result.message || "Invalid credentials";
            }
        } catch (error) {
            Swal.fire("Network Error", "Could not connect to the server.", "error");
        }
    });
</script>
@endsection
