@extends('layouts.main')

@section('content')
<main id="main" class="main">
    <!-- Button to open modal for adding new report -->
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addReportModal">Add Report</button>

    <!-- Data Table -->
    <table id="reportsTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>Report Name</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody id="reportsTableBody">
            <!-- Data will be inserted dynamically here -->
        </tbody>
    </table>

    <!-- Add Report Modal -->
    <div class="modal fade" id="addReportModal" tabindex="-1" aria-labelledby="addReportModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addReportModalLabel">Add Report</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addReportForm">
                    @csrf
                        <div class="mb-3">
                            <label for="report_name" class="form-label">Report Name</label>
                            <input type="text" class="form-control" id="report_name" name="report_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="submitReportBtn">Save Report</button>
                </div>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const token = localStorage.getItem('token');

    // Fetch and render reports in the table
    function fetchReports() {
        fetch({{ env('APP_URL') . 'api/reports'}}, {
            method: 'GET',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById('reportsTableBody');
            tableBody.innerHTML = '';
            if (data.length === 0) {
                tableBody.innerHTML = '<tr><td colspan="3" class="text-center">No data available</td></tr>';
            } else {
                data.forEach(report => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${report.report_name}</td>
                        <td>${report.description || 'No description'}</td>
                        <td>
                            <button class="btn btn-warning btn-sm" onclick="editReport(${report.id})">Edit</button>
                            <button class="btn btn-danger btn-sm" onclick="deleteReport(${report.id})">Delete</button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }
        });
    }

    document.getElementById('submitReportBtn').addEventListener('click', (event) => {
        event.preventDefault();
        const form = document.getElementById('addReportForm');
        const formData = new FormData(form);
        const reportData = {
            report_name: formData.get('report_name'),
            description: formData.get('description') || null,
        };

        fetch({{ env('APP_URL') . 'api/reports'}}, {
            method: 'POST',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            },
            body:reportData,
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Success', 'Report added successfully', 'success');
                fetchReports();
                form.reset();
                $('#addReportModal').modal('hide');
            } else {
                Swal.fire('Error', data.message || 'Failed to add report', 'error');
            }
        })
        .catch(error => {
            Swal.fire('Error', 'An error occurred while adding the report', 'error');
        });
    });

    function editReport(id) {
        const newName = prompt('Enter new report name:');
        const newDescription = prompt('Enter new description:');
        if (newName) {
            fetch(`http://127.0.0.1:8000/api/reports/${id}`, {
                method: 'PUT',
                headers: {
                    'Authorization': `Bearer ${token}`,
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ report_name: newName, description: newDescription })
            })
            .then(response => response.json())
            .then(data => {
                Swal.fire('Success', 'Report updated successfully', 'success');
                fetchReports();
            })
            .catch(error => {
                Swal.fire('Error', 'Error updating report', 'error');
            });
        }
    }

    function deleteReport(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch({{ env('APP_URL') . `api/reports/${id}`}}, {
                    method: 'DELETE',
                    headers: {
                        'Authorization': `Bearer ${token}`,
                        'Content-Type': 'application/json',
                    },
                })
                .then(response => response.json())
                .then(data => {
                    Swal.fire('Deleted!', 'Your report has been deleted.', 'success');
                    fetchReports();
                })
                .catch(error => {
                    Swal.fire('Error', 'Error deleting report', 'error');
                });
            }
        });
    }

    fetchReports();
</script>
@endsection
