@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="container">
        <div class="card shadow-lg p-4">
            <h4 class="text-center mb-3">Admin Registration Form</h4>
            <form id="registrationForm" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <input type="text" class="form-control" placeholder="First Name" name="name" required>
                    </div>
                    
                    <div class="col-md-6">
                        <input type="email" class="form-control" placeholder="Email" name="email" required>
                    </div>
                    
                    <div class="col-md-6">
                        <input type="password" class="form-control" placeholder="Password" name="password" required>
                    </div>
                    
                    <div class="col-md-6">
                        <input type="text" class="form-control" placeholder="Phone Number" name="phone_number" required>
                    </div>
                    
                    <div class="col-md-6">
                        <select class="form-control" name="role_id" id="roleSelect" required>
                            <option value="" disabled selected>Loading roles...</option>
                        </select>
                    </div>
                </div>
                
                <div class="text-center mt-3">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</main>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", async function() {
    const roleSelect = document.getElementById("roleSelect");
    const token = localStorage.getItem("token");

  

    try {
        const response = await fetch("{{ env('APP_URL') . 'api/roles'}}", {
            method: "GET",
            headers: {
                "Authorization": `Bearer ${token}`,
                "Accept": "application/json"
            }
        });

        if (!response.ok) throw new Error("Failed to fetch roles");

        const data = await response.json();
        roleSelect.innerHTML = '<option value="" disabled selected>Select Role</option>';
        data.roles.forEach(role => {
            roleSelect.innerHTML += `<option value="${role.id}">${role.name}</option>`;
        });
    } catch (error) {
        roleSelect.innerHTML = '<option value="" disabled selected>Error loading roles</option>';
    }
});

document.getElementById("registrationForm").addEventListener("submit", async function(event) {
    event.preventDefault();
    const form = event.target;
    const token = localStorage.getItem("token");

   
    // Convert FormData to JSON object
    const formData = new FormData(form);
    const jsonData = {};
    formData.forEach((value, key) => { jsonData[key] = value; });

    try {
        const response = await fetch("{{ env('APP_URL') . 'api/users'}}", {
            method: "POST",
            headers: {
                "Authorization": `Bearer ${token}`,
                "Content-Type": "application/json",
                "Accept": "application/json"
            },
            body: JSON.stringify(jsonData)
        });

        const result = await response.json();

        if (response.ok) {
            Swal.fire({
                title: "Success",
                text: "Registration completed successfully!",
                icon: "success"
            }).then(() => {
                form.reset();
            });
        } else {
            let errorMessage = result.message || "Registration failed.";
            if (result.errors) {
                errorMessage = Object.values(result.errors).flat().join("\n");
            }
            Swal.fire("Error", errorMessage, "error");
        }
    } catch (error) {
        Swal.fire("Network Error", "Could not connect to the server.", "error");
    }
});
</script>


@endsection
