@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Add New Report Component</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('report-components.index') }}">Report Components</a></li>
                <li class="breadcrumb-item active">Add</li>
            </ol>
        </nav>
    </div>

    <section class="section">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Add Report Component</h5>
                <form id="addReportComponentForm">
                    <div class="mb-3">
                        <label for="name" class="form-label">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <!-- <div class="mb-3">
                        <label for="code" class="form-label">Code</label>
                        <input type="text" class="form-control" id="code" name="code" required>
                    </div> -->
                    <div class="mb-3">
                        <label for="remark" class="form-label">Description</label>
                        <input type="text" class="form-control" id="remark" name="remark" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Add Component</button>
                </form>
            </div>
        </div>
    </section>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById('addReportComponentForm').addEventListener('submit', function (event) {
    event.preventDefault(); // Prevent the default form submission

    // Get values from the form fields
    const name = document.getElementById('name').value;
 
    const remark = document.getElementById('remark').value;

    // Get the token and user ID from local storage
    const token = localStorage.getItem('token');
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user ? user.user_id : null;

    // Prepare the payload
    const payload = {
        user_id: userId,
        name: name,
        remark: remark
    };

    // Make the API request using Fetch API
    fetch("{{ env('APP_URL') . 'api/report-components'}}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${token}`
        },
        body: JSON.stringify(payload)
    })
    .then(response => {
        if (response.status === 201) {
            return response.json();
        } else {
            return response.json().then(data => {
                Swal.fire({
                    title: 'Error!',
                    text: data.message || 'Something went wrong!',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
                throw new Error('Failed to create report component');
            });
        }
    })
    .then(data => {
        // Show success alert and reset form after confirmation
        Swal.fire({
            title: 'Success!',
            text: 'Report component added successfully!',
            icon: 'success',
            confirmButtonText: 'OK'
        }).then(() => {
            document.getElementById('addReportComponentForm').reset();
            window.location.href = "/report-components";
        });
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error!',
            text: 'Network error or failed to reach the server.',
            icon: 'error',
            confirmButtonText: 'OK'
        });
    });
});
</script>


@endsection
