@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Report Components</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Report Components</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search components...">
                    <a href="{{ route('report-components.create') }}" class="btn btn-primary">Add New Component</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="componentsTable">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Remark</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Component</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="editComponentForm">
                        <input type="hidden" id="editId">
                        <div class="mb-3">
                            <label for="editName" class="form-label">Name</label>
                            <input type="text" class="form-control" id="editName" required>
                        </div>
                        <div class="mb-3">
                            <label for="editRemark" class="form-label">Remark</label>
                            <textarea class="form-control" id="editRemark"></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="editStatus" class="form-label">Status</label>
                            <select class="form-select" id="editStatus">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-success">Save Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Component</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this component?</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const token = localStorage.getItem("token");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user ? user.user_id : null;

    const tableBody = document.querySelector("#componentsTable tbody");

    function fetchComponents() {
        fetch("{{ env('APP_URL') .  'api/report-components'}}" , {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tableBody.innerHTML = data.map(c => `
                <tr>
                    <td>${c.name}</td>
                    <td>${c.code}</td>
                    <td>${c.remark || "N/A"}</td>
                    <td>${c.status ? "Active" : "Inactive"}</td>
                    <td>
                        <button class="btn btn-sm btn-warning edit-btn" data-id="${c.id}" data-name="${c.name}" data-remark="${c.remark}" data-status="${c.status}">Edit</button>
                        <button class="btn btn-sm btn-danger delete-btn" data-id="${c.id}">Delete</button>
                    </td>
                </tr>
            `).join("");
        });
    }

    // Populate Edit Modal
    tableBody.addEventListener("click", function(e) {
        if (e.target.classList.contains("edit-btn")) {
            const btn = e.target;
            document.getElementById("editId").value = btn.dataset.id;
            document.getElementById("editName").value = btn.dataset.name;
            document.getElementById("editRemark").value = btn.dataset.remark;
            document.getElementById("editStatus").value = btn.dataset.status;
            new bootstrap.Modal(document.getElementById("editModal")).show();
        }
    });

    // Populate Delete Modal
    tableBody.addEventListener("click", function(e) {
        if (e.target.classList.contains("delete-btn")) {
            document.getElementById("deleteId").value = e.target.dataset.id;
            new bootstrap.Modal(document.getElementById("deleteModal")).show();
        }
    });

    // Submit Edit Form
    document.getElementById("editComponentForm").addEventListener("submit", function(e) {
        e.preventDefault();
        const id = document.getElementById("editId").value;
        const baseUrl = "{{ env('APP_URL') }}";
        fetch(`${baseUrl}api/report-components/${id}`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${token}`
            },
            body: JSON.stringify({
                name: document.getElementById("editName").value,
                remark: document.getElementById("editRemark").value,
                status: document.getElementById("editStatus").value,
                user_id: userId
            })
        }).then(res => res.json()).then(() => {
            fetchComponents();
            bootstrap.Modal.getInstance(document.getElementById("editModal")).hide();
        });
    });

    // Confirm Delete
    document.getElementById("confirmDeleteBtn").addEventListener("click", function () {
        const id = document.getElementById("deleteId").value;
        fetch(`${baseUrl}api/report-components/${id}`, {
            method: 'DELETE',
            headers: {
                'Authorization': `Bearer ${token}`
            }
        }).then(() => {
            fetchComponents();
            bootstrap.Modal.getInstance(document.getElementById("deleteModal")).hide();
        });
    });

    fetchComponents();
});
</script>

@endsection