@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Reports</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Reports</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search reports...">
                    <a href="#" class="btn btn-primary" id="createReportBtn">Add New Report</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="reportsTable">
                            <thead>
                                <tr>
                                    <th>Report Number</th>
                                    <th>Asset</th>
                                    <th>Created by</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <!-- <th>Status</th> -->
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Create/Edit Report Modal -->
    <div class="modal fade" id="reportModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="reportForm" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Create Report</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="reportId">
                    <input type="hidden" id="reportUserId">

                    <div class="mb-3">
                        <label class="form-label">Asset</label>
                        <select class="form-select" id="reportAssetId" required></select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="reportStartDate" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">End Date</label>
                        <input type="date" class="form-control" id="reportEndDate" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Save</button>
                </div>
            </form>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const token = localStorage.getItem("token");
    const tbody = document.querySelector("#reportsTable tbody");
    const user = JSON.parse(localStorage.getItem("user"));
    const currentUserId = user ? user.user_id : null;
    const userIdField = document.getElementById("reportUserId");

    function fetchAssets() {
        return fetch("{{ env('APP_URL') . 'api/assets'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(assets => {
            const assetSelect = document.getElementById("reportAssetId");
            assetSelect.innerHTML = `<option value="">Select Asset</option>`;
            assets.forEach(asset => {
                const option = document.createElement("option");
                option.value = asset.id;
                option.text = asset.name;
                assetSelect.appendChild(option);
            });
        });
    }

    function fetchReports() {
        fetch("{{ env('APP_URL') . 'api/reports'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tbody.innerHTML = data.map(report => `
                <tr>
                    <td>${report.report_number}</td>
                    <td>${report.asset?.name || '-'}</td>
                    <td>${report.user?.name || '-'}</td>
                    <td>${report.start_date}</td>
                    <td>${report.end_date}</td>
                    
                    <td>
                        <button class="btn btn-warning btn-sm edit-btn"
                            data-id="${report.id}"
                            data-asset_id="${report.asset?.id}"
                            data-start_date="${report.start_date}"
                            data-end_date="${report.end_date}">
                            Edit
                        </button>
                        <button class="btn btn-danger btn-sm delete-btn" data-id="${report.id}">Delete</button>
                    </td>
                </tr>
            `).join("");
        });
    }

    document.getElementById("createReportBtn").addEventListener("click", () => {
        document.getElementById("modalTitle").textContent = "Create Report";
        document.getElementById("reportForm").reset();
        document.getElementById("reportId").value = "";
        userIdField.value = currentUserId;
        new bootstrap.Modal(document.getElementById('reportModal')).show();
    });

    tbody.addEventListener("click", e => {
        const target = e.target;
        if (target.classList.contains("edit-btn")) {
            const id = target.getAttribute("data-id");
            document.getElementById("modalTitle").textContent = "Edit Report";
            document.getElementById("reportId").value = id;
            document.getElementById("reportStartDate").value = target.getAttribute("data-start_date");
            document.getElementById("reportEndDate").value = target.getAttribute("data-end_date");
            document.getElementById("reportAssetId").value = target.getAttribute("data-asset_id");
            userIdField.value = currentUserId;
            new bootstrap.Modal(document.getElementById('reportModal')).show();
        }

        if (target.classList.contains("delete-btn")) {
            const id = target.getAttribute("data-id");
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch("{{ env('APP_URL') . `api/reports/${id}`}}", {
                        method: "DELETE",
                        headers: { "Authorization": `Bearer ${token}` }
                    }).then(() => {
                        Swal.fire("Deleted!", "Report deleted.", "success");
                        fetchReports();
                    });
                }
            });
        }
    });

    document.getElementById("reportForm").addEventListener("submit", e => {
        e.preventDefault();

        const id = document.getElementById("reportId").value;
        const asset_id = document.getElementById("reportAssetId").value;
        const start_date = document.getElementById("reportStartDate").value;
        const end_date = document.getElementById("reportEndDate").value;
        const user_id = userIdField.value;

        const payload = { asset_id, start_date, end_date, user_id };

        const method = id ? 'PUT' : 'POST';
        const url = id 
            ? "{{ env('APP_URL') . `api/reports/${id}`}}" 
            : "{{ env('APP_URL') . `api/reports` }}";

        fetch(url, {
            method,
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(payload)
        })
        .then(res => res.json())
        .then(() => {
            Swal.fire(id ? 'Updated!' : 'Created!', `Report ${id ? 'updated' : 'created'} successfully.`, 'success')
            .then(() => {
                fetchReports();
                bootstrap.Modal.getInstance(document.getElementById('reportModal')).hide();
            });
        })
        .catch(() => {
            Swal.fire('Error', 'Something went wrong', 'error');
        });
    });

    // Initialize everything
    fetchAssets().then(fetchReports);
});
</script>
@endsection
