<?php

use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ExpenseTypeController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\ReportComponentController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });




Route::post('/login', [AuthController::class, 'login']);

Route::middleware('auth:sanctum')->group(function () {
    Route::put('/users/{id}', [AuthController::class, 'update']); // To update user
    Route::get('/users', [AuthController::class, 'retrieve_users']);  // To retrieve users

    Route::prefix('roles')->group(function () {
        Route::get('/', [RoleController::class, 'index']);
        Route::post('/', [RoleController::class, 'store']);
        Route::get('{role}', [RoleController::class, 'show']);
        Route::put('{role}', [RoleController::class, 'update']);
        Route::delete('{role}', [RoleController::class, 'destroy']);
    });
    
    Route::prefix('report-components')->group(function () {
        Route::get('/', [ReportComponentController::class, 'index']);
        Route::post('/', [ReportComponentController::class, 'store']);
        Route::get('{report_component}', [ReportComponentController::class, 'show']);
        Route::put('{report_component}', [ReportComponentController::class, 'update']);
        Route::delete('{report_component}', [ReportComponentController::class, 'destroy']);
    });
    
    Route::prefix('assets')->group(function () {
        Route::get('/', [AssetController::class, 'index']);
        Route::post('/', [AssetController::class, 'store']);
        Route::get('{asset}', [AssetController::class, 'show']);
        Route::put('{asset}', [AssetController::class, 'update']);
        Route::delete('{asset}', [AssetController::class, 'destroy']);
    });
    
    Route::prefix('expense-types')->group(function () {
        Route::get('/', [ExpenseTypeController::class, 'index']);
        Route::post('/', [ExpenseTypeController::class, 'store']);
        Route::get('{expense_type}', [ExpenseTypeController::class, 'show']);
        Route::put('/{expense_type}', [ExpenseTypeController::class, 'update']);
        Route::delete('/{expense_type}', [ExpenseTypeController::class, 'destroy']);
    });
    
    Route::prefix('reports')->group(function () {
        Route::get('/', [ReportController::class, 'index']);
        Route::post('/', [ReportController::class, 'store']);
        Route::get('{report}', [ReportController::class, 'show']);
        Route::put('{report}', [ReportController::class, 'update']);
        Route::delete('{report}', [ReportController::class, 'destroy']);
    });
    
    Route::prefix('incomes')->group(function () {
        Route::get('/', [IncomeController::class, 'index']);
        Route::post('/', [IncomeController::class, 'store']);
        Route::get('{income}', [IncomeController::class, 'show']);
        Route::put('{income}', [IncomeController::class, 'update']);
        Route::delete('{income}', [IncomeController::class, 'destroy']);
    });
    
    Route::prefix('expenses')->group(function () {
        Route::get('/', [ExpenseController::class, 'index']);
        Route::post('/', [ExpenseController::class, 'store']);
        Route::get('{expense}', [ExpenseController::class, 'show']);
        Route::put('{expense}', [ExpenseController::class, 'update']);
        Route::delete('{expense}', [ExpenseController::class, 'destroy']);
    });

    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('/users', [AuthController::class, 'register']); // To register user
    Route::get('/roles', [AuthController::class, 'getRoles']); 

});

