

<?php $__env->startSection('content'); ?>
<main id="main" class="main">

    <!-- Button to open modal for adding new report -->
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addReportModal">Add Report</button>

    <!-- Data Table -->
    <table id="reportsTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>Report Name</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody id="reportsTableBody">
            <!-- Data will be inserted dynamically here -->
        </tbody>
    </table>

    <!-- Add Report Modal -->
    <div class="modal fade" id="addReportModal" tabindex="-1" aria-labelledby="addReportModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addReportModalLabel">Add Report</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addReportForm">
                        <div class="mb-3">
                            <label for="report_name" class="form-label">Report Name</label>
                            <input type="text" class="form-control" id="report_name" name="report_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="submitReportBtn">Save Report</button>
                </div>
            </div>
        </div>
    </div>

</main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const token = localStorage.getItem('token'); // Get token from local storage

    // Fetch and render reports in the table
    function fetchReports() {
        fetch('http://127.0.0.1:8000/api/reports', {
            method: 'GET',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById('reportsTableBody');
            tableBody.innerHTML = ''; // Clear the table body
            if (data.length === 0) {
                tableBody.innerHTML = '<tr><td colspan="3" class="text-center">No data available</td></tr>';
            } else {
                data.forEach(report => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${report.report_name}</td>
                        <td>${report.description || 'No description'}</td>
                        <td>
                            <button class="btn btn-warning btn-sm" onclick="editReport(${report.id})">Edit</button>
                            <button class="btn btn-danger btn-sm" onclick="deleteReport(${report.id})">Delete</button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }
        });
    }

    // Add Report
    document.getElementById('submitReportBtn').addEventListener('click', () => {
        const formData = new FormData(document.getElementById('addReportForm'));
        const reportData = {
            report_name: formData.get('report_name'),
            description: formData.get('description'),
        };

        fetch('http://127.0.0.1:8000/api/reports', {
            method: 'POST',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(reportData),
        })
        .then(response => response.json())
        .then(data => {
            if (data) {
                Swal.fire('Success', 'Report added successfully', 'success');
                fetchReports(); // Refresh the table
                $('#addReportModal').modal('hide'); // Close the modal
            } else {
                Swal.fire('Error', 'Failed to add report', 'error');
            }
        })
        .catch(error => {
            Swal.fire('Error', 'Error adding report', 'error');
        });
    });

    // Edit Report
    function editReport(id) {
        // Fetch the report details and populate the modal form (implementation to be added)
        alert('Edit functionality is yet to be implemented!');
    }

    // Delete Report
    function deleteReport(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`http://127.0.0.1:8000/api/reports/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'Authorization': `Bearer ${token}`,
                        'Content-Type': 'application/json',
                    },
                })
                .then(response => response.json())
                .then(data => {
                    Swal.fire('Deleted!', 'Your report has been deleted.', 'success');
                    fetchReports(); // Refresh the table
                })
                .catch(error => {
                    Swal.fire('Error', 'Error deleting report', 'error');
                });
            }
        });
    }

    // Initial fetch of reports
    fetchReports();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\apps\jcodes\emmanuel_business\resources\views/manage_reports.blade.php ENDPATH**/ ?>